/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.ha.singleton;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.util.logging.Logger;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.protocols.FILE_PING;

public class JGroupsSafeFilePing
extends FILE_PING {
    private static final Logger LOGGER = Logger.getLogger(JGroupsSafeFilePing.class.getName());
    private static final short ID = 5683;

    @Override
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="We know what we are doing")
    public void init() throws Exception {
        File test = new File(this.location);
        String help = "The most likely cause of this problem is that the HA monitor was started before starting any Jenkins instance, and that the monitor was started as a different user (e.g. root) than the user that runs Jenkins. When the monitor is started as root, it creates the directory as root and makes it writable only by root. When later Jenkins is started as a different user, it cannot write to this directory. To fix this problem, stop the monitor, delete the directory " + this.location + " and start the monitor again after starting Jenkins.";
        if (test.exists() && !test.isDirectory()) {
            String message = "JGROUPS file location exists but is not a directory: " + test.getAbsolutePath() + "\n\n." + help;
            LOGGER.severe(message);
            throw new JenkinsHAInitException(message);
        }
        if (test.exists() && !test.canWrite()) {
            String message = "JGROUPS file location exists but is not writable: " + test.getAbsolutePath() + "\n\n." + help;
            LOGGER.severe(message);
            throw new JenkinsHAInitException(message);
        }
        super.init();
    }

    static {
        ClassConfigurator.addProtocol((short)5683, JGroupsSafeFilePing.class);
    }

    public static class JenkinsHAInitException
    extends RuntimeException {
        public JenkinsHAInitException(String message) {
            super(message);
        }

        public JenkinsHAInitException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

