/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.ha.singleton;

import com.cloudbees.jenkins.ha.singleton.ObjectInputStreamEx;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import org.jgroups.Address;
import org.jgroups.util.ExtendedUUID;

public class Identity
implements Serializable {
    transient ExtendedUUID member;
    private final int weight;
    private final int minimumSize;
    private static final long serialVersionUID = 1L;

    public Identity(int weight, int minimumSize) {
        this.weight = weight;
        this.minimumSize = minimumSize;
    }

    public Identity(boolean observer) {
        this.weight = observer ? Integer.MIN_VALUE : 0;
        this.minimumSize = 0;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="To be fixed later - BEE-13918")
    public Address getMember() {
        return this.member;
    }

    public boolean isObserver() {
        return this.weight == Integer.MIN_VALUE;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getMinimumSize() {
        return this.minimumSize;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[member=" + String.valueOf(this.member) + ",weight=" + this.weight + ",min=" + this.minimumSize + "]";
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="It does not mutate, it initializes member")
    public synchronized Address createAddress() {
        if (this.member != null) {
            throw new IllegalStateException("This identity has already been converted to address");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this);
            oos.close();
        }
        catch (IOException x) {
            throw new AssertionError((Object)x);
        }
        byte[] data = baos.toByteArray();
        this.member = ExtendedUUID.randomUUID();
        int i = 0;
        while (i * 255 < data.length) {
            this.member.put("data-" + i, Arrays.copyOfRange(data, i * 255, Math.min(data.length, (i + 1) * 255)));
            ++i;
        }
        return this.member;
    }

    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC", "OBJECT_DESERIALIZATION"}, justification="i.member is not visible elsewhere here.")
    public static Identity fromAddress(Address a, ClassLoader cl) throws Exception {
        if (a instanceof ExtendedUUID) {
            byte[] segment;
            ExtendedUUID euuid = (ExtendedUUID)a;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int i = 0;
            while ((segment = euuid.get("data-" + i)) != null) {
                baos.write(segment);
                ++i;
            }
            ObjectInputStreamEx ois = new ObjectInputStreamEx(new ByteArrayInputStream(baos.toByteArray()), cl);
            Object identity = ois.readObject();
            if (identity instanceof Identity) {
                Identity i2 = (Identity)identity;
                i2.member = euuid;
                return i2;
            }
            throw new IllegalStateException("Expecting Identity but got " + String.valueOf(identity) + " of type " + String.valueOf(identity.getClass()));
        }
        throw new IllegalArgumentException("Expecting AdditionalDataUUID but got " + String.valueOf(a) + " of type " + String.valueOf(a.getClass()));
    }
}

