/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.ha;

import com.cloudbees.jenkins.ha.singleton.Identity;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JenkinsClusterMemberIdentity
extends Identity {
    public final String typeDisplayName;
    int identityPort;
    private static final Logger LOGGER = Logger.getLogger(JenkinsClusterMemberIdentity.class.getName());
    private static final long serialVersionUID = 1L;

    public JenkinsClusterMemberIdentity(int weight, int minimumSize, String typeDisplayName) {
        super(weight, minimumSize);
        LOGGER.log(Level.FINE, "JCMI@{0} <{1}> constructed", new Object[]{this.hashCode(), typeDisplayName});
        this.typeDisplayName = typeDisplayName;
    }

    public JenkinsClusterMemberIdentity(boolean observer, String typeDisplayName) {
        this(observer ? Integer.MIN_VALUE : Integer.getInteger("com.cloudbees.jenkins.ha.weight", 0), observer ? 0 : Integer.getInteger("com.cloudbees.jenkins.ha.minimumSize", 0), typeDisplayName);
    }

    private Object readResolve() {
        LOGGER.log(Level.FINE, "JCMI@{0} <{1}> identityPort: {2}", new Object[]{this.hashCode(), this.typeDisplayName, this.identityPort});
        return this;
    }

    private Object writeReplace() {
        LOGGER.log(Level.FINE, "JCMI@{0} <{1}> identityPort: {2}", new Object[]{this.hashCode(), this.typeDisplayName, this.identityPort});
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"UNENCRYPTED_SOCKET"}, justification="Socket used to connect to loopbackAddress")
    public boolean isOnTheSameHost() {
        Socket s = new Socket();
        InetAddress loopbackAddress = null;
        try {
            loopbackAddress = InetAddress.getLoopbackAddress();
            s.connect(new InetSocketAddress(loopbackAddress, this.identityPort), 5000);
            s.shutdownOutput();
            String read = new String(s.getInputStream().readAllBytes(), Charset.defaultCharset());
            LOGGER.log(Level.FINE, "JCMI@{0} <{1}> comparing read identity {2} to my own {3}", new Object[]{this.hashCode(), this.typeDisplayName, read, this.getMember()});
            boolean bl = read.equals(this.getMember().toString());
            return bl;
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "JCMI@" + this.hashCode() + "<" + this.typeDisplayName + "> isOnTheSameHost failing to connect to " + String.valueOf(loopbackAddress) + ":" + this.identityPort, e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                s.close();
            }
            catch (IOException iOException) {}
        }
    }
}

