/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.ha;

import com.cloudbees.jenkins.ha.AbstractJenkinsSingleton;
import com.cloudbees.jenkins.ha.JenkinsClusterMemberIdentity;
import com.cloudbees.jenkins.ha.LoggerConfigurator;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jgroups.Message;

public class Demo
extends AbstractJenkinsSingleton {
    private final AtomicBoolean active = new AtomicBoolean();
    private static final String[] HOME_NAMES = new String[]{"JENKINS_HOME", "HUDSON_HOME"};

    public Demo(int weight, int min) throws IOException {
        super(new JenkinsClusterMemberIdentity(weight, min, "Demo"));
        this.homeDir = new File(".").getAbsoluteFile();
    }

    @Override
    protected String getClusterName() {
        return "chat";
    }

    @Override
    protected void promote() throws Exception {
        if (this.active.compareAndSet(false, true)) {
            System.out.println("Promoted");
        }
    }

    @Override
    protected void doDemote() {
        if (this.active.compareAndSet(true, false)) {
            System.out.println("Demoted");
        }
    }

    @Override
    public void start() {
        AbstractJenkinsSingleton.FileAndDescription home = this.getHomeDir();
        if (home != null) {
            this.setHomeDir(home.file);
        }
        super.start();
        try {
            String line;
            BufferedReader r = new BufferedReader(new InputStreamReader(System.in, Charset.defaultCharset()));
            while ((line = r.readLine()) != null) {
                this.channel.send(null, line);
            }
            this.stop();
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    @Override
    protected void onMessage(Message msg) {
        System.out.printf("[%s] %s%n", msg.getSrc(), msg.getObject());
    }

    @Override
    protected void licenseCheck() {
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="This is just demo code.")
    public AbstractJenkinsSingleton.FileAndDescription getHomeDir() {
        for (String name : HOME_NAMES) {
            try {
                InitialContext iniCtxt = new InitialContext();
                Context env = (Context)iniCtxt.lookup("java:comp/env");
                String value = (String)env.lookup(name);
                if (value != null && value.trim().length() > 0) {
                    return new AbstractJenkinsSingleton.FileAndDescription(new File(value.trim()), "JNDI/java:comp/env/" + name);
                }
                value = (String)iniCtxt.lookup(name);
                if (value == null || value.trim().length() <= 0) continue;
                return new AbstractJenkinsSingleton.FileAndDescription(new File(value.trim()), "JNDI/" + name);
            }
            catch (NamingException iniCtxt) {
                // empty catch block
            }
        }
        for (String name : HOME_NAMES) {
            String sysProp = System.getProperty(name);
            if (sysProp == null) continue;
            return new AbstractJenkinsSingleton.FileAndDescription(new File(sysProp.trim()), "System.getProperty(\"" + name + "\")");
        }
        for (String name : HOME_NAMES) {
            String env = System.getenv(name);
            if (env == null) continue;
            return new AbstractJenkinsSingleton.FileAndDescription(new File(env.trim()).getAbsoluteFile(), "System.getenv(\"" + name + "\")");
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        int weight = 0;
        int min = 0;
        if (args.length > 0) {
            weight = Integer.parseInt(args[0]);
        }
        if (args.length > 1) {
            min = Integer.parseInt(args[1]);
        }
        new Demo(weight, min).start();
    }

    static {
        new LoggerConfigurator().apply();
    }
}

